DROP PROCEDURE [hips].[SystemErrorLogInsert]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Simon Biber
-- Create date: 15 October 2012
-- Description:   Inserts a new record into the System Error Log Table
-- Modified: 24/07/2013 - Simon Biber - Added LogMessageId column
-- =============================================
CREATE PROCEDURE [hips].[SystemErrorLogInsert] 
(
      @LogMessageId INT
	, @Message VARCHAR(200)
	, @ExceptionMessage VARCHAR(500) = NULL
	, @UserModified varchar(256)
) 
AS
BEGIN
    SET NOCOUNT ON
	INSERT INTO hips.SystemErrorLog
	(
		  [LogMessageId]
		, [Message]
		, [ExceptionMessage]
        , [DateCreated]
        , [UserCreated]
        , [DateModified]
        , [UserModified]
	)
VALUES
	(
		  @LogMessageId
		, @Message
		, @ExceptionMessage
        , GETDATE()
        , @UserModified
        , GETDATE()
        , @UserModified
	)

END
GO

